{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 06.09.98 - 14:37:22 $                                        =}
{========================================================================}
unit Form_tester;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FileCtrl, MMWave, MMObj, MMUtils, MMWheel, Mask, ExtCtrls, MMVolume, MMConect,
  MMRingBf, MMWMixer, MMDSPObj, MMWavOut, MMHTimer, MMDesign, MMDIBCv,
  MMLevel, MMCstDlg, MMDSPMtr, MMLEDS, MMACMCvt, MMHook, MMAudio;
  
type
  TFormTester = class(TForm)
    MMDesigner1: TMMDesigner;
    WaveOut1: TMMWaveOut;
    RingBuffer1: TMMRingBuffer;
    Connector1: TMMConnector;
    Panel1: TPanel;
    Volume1: TMMWheel;
    Label5: TLabel;
    Label6: TLabel;
    Panning1: TMMWheel;
    FilePanel1: TPanel;
    btnFile1: TButton;
    FName1: TLabel;
    btnStart1: TButton;
    btnStop1: TButton;
    Level1: TMMLevel;
    Level2: TMMLevel;
    Panel2: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    Volume2: TMMWheel;
    Panning2: TMMWheel;
    Panel3: TPanel;
    FName2: TLabel;
    btnFile2: TButton;
    btnStart2: TButton;
    btnStop2: TButton;
    RingBuffer2: TMMRingBuffer;
    WaveOut2: TMMWaveOut;
    Connector2: TMMConnector;
    btnDevice1: TButton;
    btnDevice2: TButton;
    OpenDialog: TOpenDialog;
    AudioFile1: TMMAudioFile;
    AudioFile2: TMMAudioFile;
    Memo1: TMemo;
    Button1: TButton;
    procedure btnStartClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFileClick(Sender: TObject);
    procedure VolumeChange(Sender: TObject);
    procedure PanningChange(Sender: TObject);
    procedure WaveOut1Start(Sender: TObject);
    procedure WaveOut1Stop(Sender: TObject);
    procedure btnDeviceClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
  public
  end;

var
  FormTester: TFormTester;

implementation

{$R *.DFM}

uses form_mainform,Properties;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut1.Close;
   WaveOut2.Close;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.WaveOut1Start(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
             btnFile1.Enabled := False;
             btnDevice1.Enabled := False;
             btnStart1.Enabled := False;
             btnStop1.Enabled := True;
          end;
       1: begin
             btnFile2.Enabled := False;
             btnDevice2.Enabled := False;
             btnStart2.Enabled := False;
             btnStop2.Enabled := True;
          end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.WaveOut1Stop(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
             WaveOut1.Close;
             btnFile1.Enabled := True;
             btnDevice1.Enabled := True;
             btnStart1.Enabled := True;
             btnStop1.Enabled := False;
          end;
       1: begin
             WaveOut2.Close;
             btnFile2.Enabled := True;
             btnDevice2.Enabled := True;
             btnStart2.Enabled := True;
             btnStop2.Enabled := False;
          end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.btnDeviceClick(Sender: TObject);
begin
   with TTesterPreferences.Create(Self) do
   try
      case TControl(Sender).Tag of
          0: begin
                WaveOut := WaveOut1;
                RingBuffer:= RingBuffer1;
             end;
          1: begin
                WaveOut := WaveOut2;
                RingBuffer:= RingBuffer2;
             end;
      end;
      if mainform.tester.Visible=true then ShowModal;
   finally
      Free;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.btnStartClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
             WaveOut1.Start;
          end;
       1: begin
             WaveOut2.Start;
          end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.btnStopClick(Sender: TObject);
begin
   case TControl(Sender).Tag of
       0: begin
            // audiofile1.FadeOut(10);
             WaveOut1.Close;
          end;
       1: begin
            // audiofile2.FadeOut(10);
             WaveOut2.Close;
          end;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.btnFileClick(Sender: TObject);

   procedure UpdateFileLabel(Tag: integer);
   begin
      case Tag of
         0: FName1.Caption := MinimizeName(AudioFile1.FileName,FName1.Canvas,FName1.Width);
         1: FName2.Caption := MinimizeName(AudioFile2.FileName,FName2.Canvas,FName2.Width);
      end;
   end;

begin
  if fileexists(fname1.Caption) then
  begin
    AudioFile1.FileName := fname1.Caption;
    btnStart1.Enabled := not AudioFile1.Empty;
    UpdateFileLabel(TControl(Sender).Tag);
  end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.VolumeChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Volume := Volume1.Value;
      1: AudioFile2.Volume := Volume2.Value;
   end;
end;

{-- TMainForm -----------------------------------------------------------------}
procedure TFormTester.PanningChange(Sender: TObject);
begin
   case TControl(Sender).Tag of
      0: AudioFile1.Panning := Panning1.Value;
      1: AudioFile2.Panning := Panning2.Value;
   end;
end;

procedure TFormTester.Button1Click(Sender: TObject);
begin
   with TTesterPreferences.Create(Self) do
   try
      case TControl(Sender).Tag of
          0: begin
                WaveOut := WaveOut1;
                RingBuffer:= RingBuffer1;
             end;
          1: begin
                WaveOut := WaveOut2;
                RingBuffer:= RingBuffer2;
             end;
      end;
      //ShowModal;
   finally
      Free;
   end;
end;

end.
